// Copyright 2000, 2001, 2002, 2003 Macromedia, Inc. All rights reserved.

function havePreviewTarget()
{
	var bHavePreviewTarget = false;
	
	if (dw.getFocus(true) == 'site')
	{
		if (site.getFocus() == 'remote')
		{
			bHavePreviewTarget = site.getRemoteSelection().length > 0 &&
										site.canBrowseDocument();
		}
		else if (site.getFocus() != 'none')
		{
			var selFiles = site.getSelection();
			
			if (selFiles.length > 0)
			{
				var i;
				
				bHavePreviewTarget = true;
				
				for (i = 0; i < selFiles.length; i++)
				{
					var selFile = selFiles[i];
					var urlPrefix = "file:///";
          var strTemp = selFile.substr(urlPrefix.length);

          // If this is an FTP/RDS site, we have a target.
          if (selFile.indexOf("%%SERVER%%") != -1)
            bHavePreviewTarget = true;

          // otherwise...
          else if (selFile.indexOf(urlPrefix) == -1)
            bHavePreviewTarget = false;
          else if (strTemp.indexOf("/") == -1)
            bHavePreviewTarget = false;
          else if (!DWfile.exists(selFile))
            bHavePreviewTarget = false;
          else if (DWfile.getAttributes(selFile) == null)
            bHavePreviewTarget = true;
          else if (DWfile.getAttributes(selFile).indexOf("D") != -1)
            bHavePreviewTarget = false;
				}
			}
		}
	}
	else if (dw.getFocus() == 'document' ||
		dw.getFocus() == 'textView' || dw.getFocus("true") == 'html' )
	{
		var dom = dw.getDocumentDOM('document');
		if (dom != null)
		{
			var parseMode = dom.getParseMode();
			if (parseMode == 'html' || parseMode == 'xml')
				bHavePreviewTarget = true;
		}
	}
	
	return bHavePreviewTarget;
}

function receiveArguments()
{
	var whichBrowser = arguments[0];
	var theBrowser = null;
	var i=0;
	var browserList = null;
	var result = false;

	if (havePreviewTarget())
	{
		// Code to check if we were called from a shortcut key
		if (whichBrowser == 'primary' || whichBrowser == 'secondary')
		{
			// get the path of the selected browser
			if (whichBrowser == 'primary')
			{
				theBrowser = dw.getPrimaryBrowser();
			}
			else if (whichBrowser == 'secondary')
			{
				theBrowser = dw.getSecondaryBrowser();
			}

			// match up the path with the name of the corresponding browser
			// that appears in the menu
			browserList = dw.getBrowserList();
			while (i < browserList.length)
			{
				if (browserList[i+1] == theBrowser)
					theBrowser = browserList[i];
				i+=2;
			}
		}
		else
			theBrowser = whichBrowser;

		// Only launch the browser if we have a valid browser selected
		if (theBrowser != "file:///" && typeof(theBrowser) != "undefined" && theBrowser.length > 0)
		{
			if (dw.getFocus(true) == 'site')
			{
				// Only get the first item of the selection because
				// browseDocument() can't take an array.
				//dw.browseDocument(site.getSelection()[0],theBrowser);
				site.browseDocument(theBrowser);
			}
			else
				dw.browseDocument(dw.getDocumentPath('document'),theBrowser);
		}
		else
		{
			// otherwise, if the user hit the F12 or Ctrl+F12 keys,
			// ask if they want to specify a primary or secondary browser now.
			if (whichBrowser == 'primary')
			{
				result = window.confirm(MSG_NoPrimaryBrowserDefined);
			}
			else if (whichBrowser == 'secondary')
			{
				result = window.confirm(MSG_NoSecondaryBrowserDefined);
			}

			// If they clicked OK, show the prefs dialog with the browser panel
			if (result)
				dw.showPreferencesDialog('browsers');
		}
	}
}

function canAcceptCommand()
{
	var PIB = dw.getBrowserList();

	if (arguments[0] == 'primary' || arguments[0] == 'secondary')
		return havePreviewTarget();

	return havePreviewTarget() && (PIB.length > 0);
}

// getDynamicContent returns the contents of a dynamically generated menu.
// returns an array of strings to be placed in the menu, with a unique
// identifier for each item separated from the menu string by a semicolon.
//
// return null from this routine to indicate that you are not adding any
// items to the menu
function getDynamicContent(itemID)
{
	var browsers = null;
	var PIB = null;
	var i;
	var j=0;
	browsers = new Array();
	PIB = dw.getBrowserList();
	// each browser pair has the name of the browser and the path that leads
	// to the application on disk. We only put the names in the menus
	for (i=0; i<PIB.length; i=i+2)
	{
		browsers[j] = new String(PIB[i]);

		if (dw.getPrimaryBrowser() == PIB[i+1])
		   browsers[j] += "\tF12";
		else if (dw.getSecondaryBrowser() == PIB[i+1])
		  browsers[j] += "\tCmd+F12";

		browsers[j] += ";id='"+escQuotes(PIB[i])+"'";

		if (itemID == "DWPopup_PIB_Default")
			browsers[j] = MENU_strPreviewIn + browsers[j];
		
		j = j+1;
	}
	return browsers;
}
